
* ==================================================================================================
* ========================= INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS - INEC ===========================
* ================== DIRECCIN DE ESTADSTICAS AGROPECUARIAS Y AMBIENTALES - DEAGA ====================
* ========================== REGISTRO INTEGRAL DE RESIDUOS SLIDOS- GIRS 2024 ==========================
* ============================= SINTAXIS DE ELABORACIN DE INDICADORES================================
* ============================= ELABORADO POR: WILSON MONTEROS=====================================
* =======================================NOVIEMBRE 2025 ==============================================
* ======================================= INDICADORES  ==============================================


***********************************MUNICIPIOS***********************************

******************CLCULO DE INDICADORES RESIDUOS 2021***********


compute base = 1.
execute.


**************************INDICADOR 1*******************************************

***GAD MUNICIPALES QUE CUENTAN CON MODELO DE GESTIN****


*Gestin Directa.
IF (MR111 = 1) MGD = 1.
IF (MR111 = 2) MGD = 0 .
VARIABLE LABELS MGD 'Municipios con Gestin Directa' .
value labels MGD 1'Si' 0 'No'.



* Empresa Municipal.
IF (MR1131 = 1) MEP = 1.
IF (MR1131 = 2) MEP = 0.
IF (MR1131 = 3) MEP = 0.
VARIABLE LABELS MEP 'Municipios con Empresa Municipal' .
value labels MEP 1'Si' 0 'No'.



* Mancomunidad.
IF (MR112 = 1) MM = 1.
IF (MR112 = 2) MM = 0.
VARIABLE LABELS MM 'Municipios con Mancomunidad' .
value labels MM 1'Si' 0 'No'.



* Empresa Pblica Mancomunada.
IF (MR1131 = 1) EPM = 0.
IF (MR1131 = 2) EPM = 1.
IF (MR1131 = 3) EPM = 0.
VARIABLE LABELS EPM 'Municipios con Empresa Pblica Mancomunada' .
value labels EPM 1'Si' 0 'No'.



* Gestin Directa, Mancomunidad y Empresa.
IF ((MR111 = 1 & MR112 = 1) | (MR111 = 1 & MR113 = 1)) MGC = 1.
IF ((MR111 = 2 | MR112 = 2) & (MR111 = 2 | MR113 = 2)) MGC = 0.
VARIABLE LABELS MGC 'Municipios con Gestin Combinada' .
value labels MGC 1'Si' 0 'No'.



* Modelo de Gestin.
IF (MGD = 1) MMG = 1.
IF (MEP = 1) MMG = 2.
IF (MM = 1) MMG = 3.
IF (EPM = 1) MMG = 4.
IF (MGC = 1) MMG = 5.
VARIABLE LABELS MMG 'Municipios segn modelo de gestin' .
value labels MMG 1'Gestin Directa' 2 'Empresa Municipal' 3'Mancomunidad' 4' Empresa Pblica Mancomunada' 5' Gestin Combinada'.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu Provin MMG DISPLAY=LABEL
  /TABLE rgnatu [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + Provin [C][COUNT F40.0, ROWPCT.COUNT 
    PCT40.1] BY MMG [C]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=MMG [1.00, 2.00, 3.00, 4.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER    
  /TITLES
    TITLE='Porcentaje de GADs Municipales que cuentan con un Modelo de Gestin'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



**************************INDICADOR 2*******************************************

****COBERTURA DEL SERVISIO DE BARRIDO (Municipios que si constan con calles susceptibles a ser barridas)*****


USE ALL.
COMPUTE filter_$=( MR422 = 1).
VARIABLE LABEL filter_$ 'MR422 = 1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.



********Sumatoria de Vias Barridas (Manual y Mecanico)*****.


COMPUTE VB = sum.1(MR42313, MR42423).
VARIABLE LABELS VB 'Vias Barridas'.
execute.


********Calculo de cobertura de servicio******************.


compute CSB = VB / MR4223.
variable labels CSB 'Cobertura de Servicio de Barrido'.
execute.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu Provin VB MR4223 CSB DISPLAY=LABEL
  /TABLE rgnatu + Provin BY VB [SUM] + MR4223 [SUM] + CSB [MEAN, , VALIDN F40.0] 
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Cobertura de Servicio de Barrido (Municipios que si constan con calles susceptibles a ser barridas)'
    CAPTION='Fuente:AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.


filter off.

*Nota: La cobertura hay que calcularla en el programa Excel. 



**************************INDICADOR 3*******************************************


****PROPORCIN DE GADS MUNICIPALES QUE HAN INICIADO O MANTIENEN PROCESOS DE SEPARACIN EN LA FUENTE****


*****Separacin en la Fuente a Nivel Domiciliar*****.


IF (MR433 = 1) MSF = 1 .
IF (MR433 = 2) MSF = 0 .

value labels MSF 0'No' 1'Si'.
VARIABLE LABELS MSF 'Municipios con Separacin en la Fuente' .
execute.

* Tablas personalizadas. 
CTABLES 
  /VLABELS VARIABLES=rgnatu Provin MSF DISPLAY=LABEL 
  /TABLE rgnatu [C][COUNT F40.0, ROWPCT.VALIDN PCT40.2] + Provin [C][COUNT F40.0, ROWPCT.VALIDN 
    PCT40.2] BY MSF [C] 
  /CATEGORIES VARIABLES=rgnatu [1.00, 2.00, 3.00, 4.00] EMPTY=INCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE 
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
    20, 21, 22, 23, 24] EMPTY=INCLUDE 
  /CATEGORIES VARIABLES=MSF ORDER=D KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER 
  /TITLES 
    TITLE='Proporcin de Gads Municipales que ha iniciado o mantienen Procesos de Separacin en '+ 
    'la Fuente: ' 
    CORNER='Regiones y Provincias' 
    CAPTION='Fuente: INEC -Municipios - Gestin Integral de Residuos Slidos 2024'.  




******************************************INDICADOR 4**********************************



**** RESIDUOS SLIDOS RECOLECTADOS AL DA****


****Diferenciada suma de Orgnico e Inorgnico**********.


compute DIF = sum.1 (MR4522, MR4523).
variable  labels DIF 'Diferenciada:  ton/da'.
execute.


*** No diferenciada la resta de Total cantidad de residuos recolectados - Diferenciada.****

compute DIF2 = DIF * -1.
compute NODIF = sum.1(MR453, DIF2).
variable labels NODIF 'No Diferenciada: ton/da'.
execute.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu Provin MR4522 MR4523 DIF NODIF MR453
    DISPLAY=LABEL
  /TABLE rgnatu + Provin BY MR4522 [SUM, VALIDN F40.0] + MR4523 [SUM, VALIDN F40.0] + DIF [SUM, VALIDN F40.0] + NODIF [SUM, VALIDN F40.0] + MR453 [SUM, VALIDN F40.0]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Residuos Slidos Recolectados al da'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.




**************************INDICADOR 5*******************************************



**** DISPISICIN FINAL DE RESIDUOS SLIDOS (GADS MUNICIPALES)  ****



* Tablas personalizadas. 
CTABLES 
  /VLABELS VARIABLES=rgnatu Provin MR461 DISPLAY=LABEL 
  /TABLE rgnatu [C][COUNT F40.0, ROWPCT.VALIDN PCT40.2] + Provin [C][COUNT F40.0, ROWPCT.VALIDN 
    PCT40.2] BY MR461 [C] 
  /CATEGORIES VARIABLES=rgnatu [1.00, 2.00, 3.00, 4.00] EMPTY=INCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE 
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
    20, 21, 22, 23, 24] EMPTY=INCLUDE 
  /CATEGORIES VARIABLES=MR461 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER 
  /TITLES 
    TITLE='Para la Disposicin Final de los Residuos Slidos, el Municipio cuenta con:' 
    CORNER='Regiones y Provincias' 
    CAPTION='Fuente: INEC -Municipios - Gestin Integral de Residuos Slidos 2024'.  



*****************************************INDICADOR 6*******************



****RECOLECCIN DIFERENCIADA DE DESECHOS SANITARIOS PELIGROSOS (GADS MUNICIPALES)****



IF (MR473111 = 1 or MR473121 = 1) RDES = 1.
recode RDES (SYSMIS=0).
value labels RDES 1'Si' 0'No'.
VARIABLE LABELS RDES 'Municipios con Recoleccin Diferenciada de Desechos Sanitarios Peligrosos' .
frequencies RDES.



* Tablas personalizadas. 
CTABLES 
  /VLABELS VARIABLES=rgnatu Provin RDES DISPLAY=LABEL 
  /TABLE rgnatu [C][COUNT F40.0, ROWPCT.VALIDN PCT40.2] + Provin [C][COUNT F40.0, ROWPCT.VALIDN 
    PCT40.2] BY RDES [C] 
  /CATEGORIES VARIABLES=rgnatu [1.00, 2.00, 3.00, 4.00] EMPTY=INCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE 
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
    20, 21, 22, 23, 24] EMPTY=INCLUDE 
  /CATEGORIES VARIABLES=RDES ORDER=D KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER 
  /TITLES 
    TITLE='Municipios que cuentan con Recoleccin Diferenciada de Desechos Sanitarios Peligrosos ' 
    CORNER='Regiones y Provincias' 
    CAPTION='Fuente: INEC -Municipios - Gestin Integral de Residuos Slidos 2024'.  




**************************INDICADOR 7*******************************************


***** MANEJO FINAL DE DESECHOS PELIGROSOS GENERADOS DE ESTABLECIMIENTOS DE SALUD. ****


if (MR47375 = 1 ) MFDPES = 1.
if (MR473711 = 1 ) MFDPES = 2.
if (MR473711 = 2 ) MFDPES = 3.
if (MR473711 = 3 OR MR473711 = 4 ) MFDPES = 4.
if (MR4737 = 2 ) MFDPES = 5.
value labels MFDPES
1 'Celda Exclusiva'
2 'Autoclave'
3 'Incineracin'
4 'Otros'
5 'No cuenta con sistema de tratamiento y/o disposicin final Desechos Peligrosos Sanitarios'.
variable labels MFDPES 'Manejo Final de Desechos Peligrosos Generados de Establecimientos de Salud'.
EXECUTE.

recode MFDPES (SYSMIS=5).


* Tablas personalizadas. 
CTABLES 
  /VLABELS VARIABLES=rgnatu Provin MFDPES DISPLAY=LABEL 
  /TABLE rgnatu [C][COUNT F40.0, ROWPCT.VALIDN PCT40.2] + Provin [C][COUNT F40.0, ROWPCT.VALIDN 
    PCT40.2] BY MFDPES [C] 
  /CATEGORIES VARIABLES=rgnatu [1.00, 2.00, 3.00, 4.00] EMPTY=INCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE 
  /CATEGORIES VARIABLES=Provin [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
    20, 21, 22, 23, 24] EMPTY=INCLUDE 
  /CATEGORIES VARIABLES=MFDPES ORDER= A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER 
  /TITLES 
    TITLE='Manejo Final de Desechos Peligrosos generados de Establecimientos de Salud. ' 
    CORNER='Regiones y Provincias' 
    CAPTION='Fuente: INEC -Municipios - Gestin Integral de Residuos Slidos 2024'.  



**************************INDICADOR 8*******************************************


*********SUBSIDIO DE LA GESTIN INTEGRAL DE RESIDUOS SLIDOS******



*****Gasto total************.

compute CT =  MR2112.
variable labels CT 'Gasto Total por Gestin Integral de Residuos Slidos: Dlares/mes'.
execute.


**** Ingreso Mensual******.

compute IM = MR2214.
variable labels IM 'Ingresos mensuales por concepto de Tasa/Tarifa u Otros ingresos de la GIRS'. 
EXECUTE.


****Valor Subsidiado*******.

compute IM2 = IM * -1.
compute VS = sum.1( CT, IM2).
execute.



*Clculo del Subsidio.
compute SUBSIDIO = 1.
IF (IM>=CT) SUBSIDIO = 0.
VARIABLE LABELS SUBSIDIO 'Condicin de Subsidio' .
value labels SUBSIDIO 1'SUBSIDIO' 0 'NO SUBSIDIO'.
execute.


DATASET COPY  SUBSIDIO.
DATASET ACTIVATE  SUBSIDIO.
FILTER OFF.
USE ALL.
SELECT IF (SUBSIDIO = 1).
EXECUTE.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu Provin CT IM VS SUBSIDIO   
    DISPLAY=LABEL
  /TABLE rgnatu + Provin BY CT [SUM] + IM [SUM] + VS [SUM] + SUBSIDIO [COUNT, VALIDN F40.0]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Subsidio de la Gestin Integral de Residuos Slidos'
    CAPTION='Fuente: INEC - AME- Municipios-Registro Integral de Residuos Slidos -GIRS 2024'.


DATASET CLOSE SUBSIDIO.




**************************INDICADOR 9*******************************************.


***PROPORCIN DE RESIDUOS SLIDOS RECOLECTADOS****.



compute ROTZU = MR4441 / 1000.
variable labels ROTZU 'Cantidad de Residuos Orgnicos Tratados en la Zona Urbana: Tonelada/mes'.
execute.

compute ROTZR = MR4442 / 1000.
variable labels ROTZR 'Cantidad de Residuos Orgnicos Tratados en la Zona Rural: Tonelada/mes'.
execute.

compute TROT = sum.1 (ROTZU, ROTZR).
variable labels TROT 'Cantidad Total de Residuos Orgnicos Tratados: Tonelada/mes'.
execute.


compute RI = MR4341_TOTAL_RES_REC / 12.
variable labels RI 'Residuos Inorgnicos Recuperados: Kgs/mes'.
execute.

compute RIR = RI / 1000.
variable labels RIR 'Residuos Inorgnicos Recuperados: Tonelada/mes'.
execute.

compute CRR = MR453 * 30.
variable labels CRR 'Cantidad de Residuos Slidos Recolectados: Tonelada/mes'.
execute.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu Provin ROTZU ROTZR TROT RIR CRR  
    DISPLAY=LABEL
  /TABLE rgnatu [C] + Provin [C] BY ROTZU [S][SUM, ROWPCT.VALIDN PCT40.1] + ROTZR [S][SUM, 
    ROWPCT.VALIDN PCT40.1] + TROT [S][SUM, ROWPCT.VALIDN PCT40.1] + RIR [S][SUM, ROWPCT.VALIDN PCT40.1] 
    + CRR [S][SUM, VALIDN F40.0]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Proporcin de Residuos Slidos Recuperados'
    CAPTION='Fuente: INEC - AME- Municipios-Registro Integral de Residuos Slidos -GIRS 2024'.


*Nota: El clculo de los porcentajes para cada tem hay que hacerlo manualmente en Excel.



**************************INDICADOR 10*******************************************


****PRODUCCIN PER CPITA DE DESECHOS SLIDOS (URBANO)****


compute RGEN = Pob*MR4321.
execute.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu Provin RGEN Pob DISPLAY=LABEL
  /TABLE rgnatu [C] + Provin [C] BY RGEN [S][SUM, VALIDN F40.0] + Pob [S][SUM, VALIDN F40.0]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' POSITION=BEFORE
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Produccin Per Cpita de Desechos Slidos (Urbano)'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.




**************************INDICADOR 11*******************************************


*******COSTO DE GESTIN MENSUAL POR TONELADA DE BASURA******


compute CTGIRS = CT / MR243.
variable labels CTGIRS 'Costo Tonelada/mes de la Gestin Integral de Residuos Slidos: USD/mes'.
execute.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu Provin CT MR243 CTGIRS  DISPLAY=LABEL
  /TABLE rgnatu [C] + Provin [C] BY CT [S][SUM] + MR243 [S][SUM] + CTGIRS [S][MEAN, VALIDN F40.0] 
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Costo de Gestin Mensual por tonelada de Basura'
    CAPTION='Fuente: INEC - AME- Municipios-Registro Integral de Residuos Slidos -GIRS 2024'.

*Nota: El clculo del costo por tonelada hay que hacerlo manualmente en Excel .





**************************INDICADOR 12*******************************************

****RESIDUOS SLIDOS DEPOSITADOS EN EL SITIO DE DISPOSICIN FINAL, SEGN SITIO (PRINCIPAL)******


*Nota: El clculo del costo por tonelada hay que hacerlo manualmente en Excel .


Compute MR48_CAL = sum.1(MR48,-MR483).
execute.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=rgnatu Provin MR461 MR48_CAL DISPLAY=LABEL
  /TABLE rgnatu [C] + Provin [C] BY MR461 [C] > MR48_CAL [S][SUM, MEAN, ROWPCT.COUNT PCT40.1, 
  VALIDN F40.0]
  /CATEGORIES VARIABLES=rgnatu [1, 2, 3, 4, 5, OTHERNM] EMPTY=EXCLUDE TOTAL=YES LABEL='Nacional' 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=Provin ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=MR461 [1, 2, 3, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Cantidad de residuos slidos depositados en el sitio de Disposicin Final, segn sitio (principal) de disposicin final'
    CAPTION='Fuente: AME-INEC. 2024, Registro de Gestin Integral de Residuos Slidos.'.



**********************************************************************************************************************
*******************************************FIN***********************************************************************
